

libname q 'c:\SASCodeforBook\SASDataSets';

Data First; set q.frauddata;
	/*this recodes bodily injury workers on zero to one scale*/
bodinjury=.;
if DBIPIP=2 then bodinjury =1;
if DBIPIP=1 then bodinjury =0;
	/*This code renames the variables for easy reading*/
DichoAntiIndex = dantidex;
Targetoffice = target;
bodilyinjury = bodinjury;
newadminsys = impv2k;
run;


Data second; set first;	

	/* Estimates for the Linear Probability Model with three explanatory variables*/

	/* This Code Produces the parameters for chapter 3,equation 18*/
Title 'Estimates for the Linear Probability Model, Unstandardized Coefficients eq. 18'; 
proc reg data=second;
	model DichoAntiIndex = targetoffice bodilyinjury newadminsys /stb tol vif;
run;

	/*This code provides the means of the variables*/
Title 'Means of the four variables in this illustrative analysis';	
	Proc Means; 
	var  DichoAntiIndex targetoffice bodilyinjury newadminsys; 

Title 'Means Used in chapter 3, Equation 20, No Missing Option';
	Proc Corr nomiss; 
	var  DichoAntiIndex targetoffice bodilyinjury newadminsys; 
run;

data third; set first;

/*This Code Standardizes two covariates but not the target versus control indicator*/
Title 'BodilyInjury and NewAdminSys will have zero means';
	proc standard data=third out=standard mean=0;
	var bodilyinjury newadminsys;
run;

Title 'Check: DichAntiIndex and TargetOffice are not standardized with zero means,
	BodilyInjury and NewAdminSys are standardized with zero means';	
	proc means data=standard;
	var DichoAntiIndex targetoffice bodilyinjury newadminsys;
run;

Title 'The effects of two covariates appear in the modified intercept term eq 19';
	Proc Reg data=standard;
	model DichoAntiIndex = targetoffice bodilyinjury newadminsys /stb tol vif;
run;

			/* Multiplicative Decomposition of Effects*/

Title 'Estimates for Model of Chapter 3, Equation 27 covariates centered by means of zero';
	proc logistic descending data=standard;
	model DichoAntiIndex = targetoffice bodilyinjury newadminsys;
run;

Title 'Estimates for Model of Chapter 3, Equation 28'no variables centered by means;
	proc logistic descending data=third ;
	model DichoAntiIndex = targetoffice bodilyinjury newadminsys;
run; 

		/* This code completes the examples for chapter 3*/
		/* This syntax is copyright by Robert B. Smith  2011*/
